#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <yandex/maps/wiki/social/feedback/review.h>
#include <string>

namespace maps::wiki::socialsrv {
class CreateReview;
} // namespace maps::wiki::socialsrv

namespace maps::wiki::controller {
template<>
struct ResultType<maps::wiki::socialsrv::CreateReview>
{
    std::string resultJson;
};
} // namespace maps::wiki::controller

namespace maps::wiki::socialsrv {

class CreateReview : public controller::BaseController<CreateReview>
{
public:
    struct Request
    {
        std::string dump() const;
        social::TUid userId() const { return uid; }

        const social::TId regionId;
        const social::TUid uid;
    };

    CreateReview(const Request& request, taskutils::TaskID asyncTaskID);

    std::string printRequest() const override { return request_.dump(); }
    static const std::string& taskName();
protected:
    void control() override;

private:
    const Request request_;
};

} // namespace maps::wiki::socialsrv
