#include "delete_review.h"
#include "helpers.h"
#include <maps/wikimap/mapspro/services/social/src/api/globals.h>
#include <maps/wikimap/mapspro/services/social/src/libs/yacare/error.h>

namespace maps::wiki::socialsrv {
namespace {
const std::string TASK_NAME = "DeleteReview";
} // namespace

DeleteReview::DeleteReview(
        const Request& request,
        taskutils::TaskID asyncTaskID)
    : controller::BaseController<DeleteReview>(DeleteReview::taskName(), asyncTaskID)
    , request_(request)
{ }

std::string DeleteReview::Request::dump() const
{
    return
        "review-id: " + std::to_string(reviewId) +
        " uid: " + std::to_string(uid);
}

void DeleteReview::control()
{
    checkPermissionsToWorkWithReviews(request_.uid, ReviewAccessMode::Edit);
    const auto reviewId = request_.reviewId;
    auto writeContext = Globals::dbPools().writeContext();
    auto& socialWriteTxn = writeContext.socialTxn();
    mwsf::ReviewsGateway gw(socialWriteTxn);
    auto review = gw.getReview(reviewId);
    SOCIAL_REQUIRE(review.createdBy() == request_.uid, Forbidden,
        "Forbidden to deleted others reviews.");
    SOCIAL_REQUIRE(review.state() == mwsf::ReviewState::Draft, InvalidOperation,
        "Only draft reviews can be deleted.");
    gw.deleteReview(reviewId);
    auto token = writeContext.commit();
    result_->resultJson = toJson(token);
}

const std::string&
DeleteReview::taskName()
{
    return TASK_NAME;
}

} // namespace maps::wiki::socialsrv
