#include <maps/wikimap/mapspro/services/social/src/api/globals.h>
#include "helpers.h"
#include "create_review.h"
#include "delete_review.h"
#include "get_review.h"
#include "save_review.h"
#include "controller_async.h"
#include <yandex/maps/wiki/social/feedback/review.h>
#include <yandex/maps/wiki/social/feedback/reviews_gateway.h>

#include <maps/wikimap/mapspro/services/social/src/libs/common/common.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/common.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/serialize.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/review_report.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/review_utils.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/feedback_review_serialize.h>

#include <maps/wikimap/mapspro/services/social/src/libs/yacare/helpers.h>

#include <maps/wikimap/mapspro/libs/taskutils/include/taskmanager.h>
#include <maps/wikimap/mapspro/libs/controller/include/asynctaskresult.h>
#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/serialization.h>
#include <maps/libs/log8/include/log8.h>

YCR_QUERY_PARAM(limit, size_t);

YCR_QUERY_CUSTOM_PARAM((), regionId, maps::wiki::social::TId)
{
    return yacare::impl::parseArg(dest, request, "region-id", true);
}

YCR_QUERY_CUSTOM_PARAM((), reportLang, std::string)
{
    if (request.input().has("report-lang")) {
        return yacare::impl::parseArg(dest, request, "report-lang");
    } else {
        dest = "ru";
    }
    return true;
}

namespace maps::wiki::socialsrv {

namespace mws = social;
namespace mwsf = social::feedback;

namespace {
yacare::ThreadPool feedbackReviewThreadPool("feedbackReviewThreadPool", 2, 2048);
} // namespace

YCR_USE(feedbackReviewThreadPool) {

YCR_RESPOND_TO("POST /feedback/mrc_pedestrian_region_reviews", uid, regionId)
{
    CreateReview::Request request {
        .regionId = regionId,
        .uid = uid
    };
    ControllerAsync<CreateReview> worker(request);
    makeJsonResponse(response, worker()->toJson());
}

YCR_RESPOND_TO("GET /feedback/mrc_pedestrian_region_reviews", uid, regionId, limit, token)
{
    checkPermissionsToWorkWithReviews(uid, ReviewAccessMode::View);
    auto socialReadTxn = Globals::dbPools().socialReadTxn(token);
    makeJsonResponse(
        response,
        toJson(
            mwsf::ReviewsGateway(
                *socialReadTxn)
                    .getRecentRegionReviews(regionId, limit)));
}

YCR_RESPOND_TO("GET /feedback/mrc_pedestrian_region_reviews/$", uid, token)
{
    GetReview::Request controllerRequest {
        .uid = uid,
        .reviewId = positionalParam<TId>(argv, 0),
        .token = token
    };
    ControllerAsync<GetReview> worker(controllerRequest);
    makeJsonResponse(response, worker()->toJson());
}

YCR_RESPOND_TO("POST /feedback/mrc_pedestrian_region_reviews/$", uid)
{
    SaveReview::Request controllerRequest {
        .uid = uid,
        .reviewId = positionalParam<TId>(argv, 0),
        .requestBody = request.body(),
        .lang = "",
        .mode = SaveReview::Mode::Save
    };
    ControllerAsync<SaveReview> worker(controllerRequest);
    makeJsonResponse(response, worker()->toJson());
}


YCR_RESPOND_TO("PUT /feedback/mrc_pedestrian_region_reviews/$/delete", uid)
{
    DeleteReview::Request controllerRequest {
        .uid = uid,
        .reviewId = positionalParam<TId>(argv, 0)
    };
    ControllerAsync<DeleteReview> worker(controllerRequest);
    makeJsonResponse(response, worker()->toJson());
}

YCR_RESPOND_TO("POST /feedback/mrc_pedestrian_region_reviews/$/report", uid, reportLang)
{

    SaveReview::Request controllerRequest {
        .uid = uid,
        .reviewId = positionalParam<TId>(argv, 0),
        .requestBody = request.body(),
        .lang = reportLang,
        .mode = SaveReview::Mode::Publish
    };
    ControllerAsync<SaveReview> worker(controllerRequest);
    makeJsonResponse(response, worker()->toJson());
}

YCR_RESPOND_TO("GET /results/$")
{
    const auto& asyncTasksSupport = Globals::asyncTasksSupport();
    const auto& tokenSecretWord = asyncTasksSupport.manager().tokenSecretWord();
    auto asyncTaskResult = std::make_unique<controller::AsyncTaskResult>(
        taskutils::Token(
            positionalParam<std::string>(argv, 0),
            tokenSecretWord));
    asyncTaskResult->load(asyncTasksSupport);
    makeJsonResponse(response, asyncTaskResult->toJson());
}


} // YCR_USE(feedbackTasksThreadPool)

} // namespace maps::wiki::socialsrv
