#include "helpers.h"
#include <maps/wikimap/mapspro/services/social/src/api/globals.h>
#include <maps/wikimap/mapspro/services/social/src/libs/yacare/error.h>

namespace maps::wiki::socialsrv {

void checkPermissionsToWorkWithReviews(TUid uid, ReviewAccessMode accessMode)
{
    Globals::aclChecker()
        .checkPermission(
            uid,
            accessMode == ReviewAccessMode::View
                ? FEEDBACK_REVIEW_PERMISSION_VIEW
                : FEEDBACK_REVIEW_PERMISSION_EDIT
        );
}

void checkAccessToReviewContents(
    const ReviewExternData& reviewExternData,
    TUid uid)
{
    const auto& feedbackChecker = Globals::feedbackChecker();
    for (const auto& task : reviewExternData.tasks) {
     SOCIAL_REQUIRE(
        feedbackChecker.isAllowedToView(task, {}, uid),
        Forbidden,
        "Task with id " << task.id() << " is forbidden for user " << uid);
    }
}

} // namespace maps::wiki::socialsrv
