#include "save_review.h"
#include "helpers.h"
#include <maps/wikimap/mapspro/services/social/src/api/globals.h>
#include <maps/wikimap/mapspro/services/social/src/libs/yacare/error.h>

namespace maps::wiki::socialsrv {
namespace {
const std::string TASK_NAME = "SaveReview";
} // namespace

SaveReview::SaveReview(
        const Request& request,
        taskutils::TaskID asyncTaskID)
    : controller::BaseController<SaveReview>(SaveReview::taskName(), asyncTaskID)
    , request_(request)
{ }

std::string SaveReview::Request::dump() const
{
    return
        "review-id: " + std::to_string(reviewId) +
        " uid: " + std::to_string(uid) +
        " lang: " + lang;
}

void SaveReview::control()
{
    checkPermissionsToWorkWithReviews(request_.uid, ReviewAccessMode::Edit);
    const auto reviewId = request_.reviewId;
    auto writeContext = Globals::dbPools().writeContext();
    auto& socialWriteTxn = writeContext.socialTxn();
    mwsf::ReviewsGateway gw(socialWriteTxn);
    auto review = gw.getReview(reviewId);
    SOCIAL_REQUIRE(review.createdBy() == request_.uid, Forbidden,
        "Forbidden to modify others reviews.");
    updateReviewFromJson(review, request_.requestBody);
    const auto reviewExternData = getReviewExternData(
        review,
        writeContext.coreTxn(),
        socialWriteTxn, request_.mode == SaveReview::Mode::Publish
        ? IncludeTasksWithoutComments::No
        : IncludeTasksWithoutComments::Yes);
    if (request_.mode == SaveReview::Mode::Publish) {
        review.setPublished(makePdfReportAndUpload(
            review,
            reviewExternData,
            request_.lang,
            Globals::fbReviewTranslations(),
            Globals::tvmClient(),
            Globals::mdsConfiguration(),
            Globals::mrcBrowserProUrl()));
    }
    review = gw.saveReview(review);
    auto token = writeContext.commit();
    result_->resultJson = toJson(review, token, request_.uid, reviewExternData);
}

const std::string&
SaveReview::taskName()
{
    return TASK_NAME;
}

} // namespace maps::wiki::socialsrv
