#pragma once

#include <maps/wikimap/mapspro/services/social/src/libs/common/db_pools.h>
#include <maps/wikimap/mapspro/libs/controller/include/async_tasks_support.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/caching_acl.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/feedback.h>
#include <maps/wikimap/mapspro/libs/sqs_client/include/configuration.h>
#include <maps/wikimap/mapspro/libs/assessment/include/rate_limiter.h>
#include <yandex/maps/wiki/social/rate_limiter.h>

#include <maps/libs/json/include/value.h>
#include <yandex/maps/mds/mds.h>

#include <aws/sqs/SQSClient.h>
#include <library/cpp/tvmauth/client/facade.h>

namespace maps::wiki {

namespace common {

class ExtendedXmlDoc;

} // namespace common

namespace socialsrv {

struct GlobalsScope {
    explicit GlobalsScope(const common::ExtendedXmlDoc& config);
    ~GlobalsScope();
};

struct Globals
{
    static const sqs::Configuration& sqsConfig();
    static const Aws::SQS::SQSClient& sqsClient();
    static DbPoolsWithViewTrunk& dbPools();
    static acl_utils::CachingAclChecker& aclChecker();
    static const acl_utils::FeedbackChecker& feedbackChecker();
    static const assessment::RateLimiter& assessmentRateLimiter();
    static const social::RateLimiter& socialRateLimiter();
    static const json::Value& fbReviewTranslations();
    static const NTvmAuth::TTvmClient& tvmClient();
    static const mds::Configuration& mdsConfiguration();
    static const std::string& mrcBrowserProUrl();
    static const controller::AsyncTasksSupport& asyncTasksSupport();
    static bool feedbackReviewNewTasksOnly();
};

} // namespace socialsrv

} // namespace maps::wiki
