#include <maps/wikimap/mapspro/services/social/src/libs/common/common.h>
#include <maps/wikimap/mapspro/services/social/src/api/globals.h>
#include <maps/wikimap/mapspro/services/social/src/libs/yacare/helpers.h>

#include <yandex/maps/wiki/social/gateway.h>

namespace srv = maps::wiki::socialsrv;

namespace {

const std::string STR_NULL = "null";
const std::string STR_TOKEN = "token";

yacare::ThreadPool usersThreadPool("usersThreadPool", 2, 1024);

} // namespace

YCR_USE(usersThreadPool) {

YCR_RESPOND_TO("GET /users/$/data", token = "")
{
    auto uid = srv::positionalParam<srv::UserId>(argv, 0);
    srv::checkUid(uid);

    auto userdata = [&] {
        auto socialTxn = srv::Globals::dbPools().socialReadTxn(token);
        maps::wiki::social::Gateway gateway(*socialTxn);

        return gateway.getUserData(uid);
    }();

    srv::makeJsonResponse(response, userdata ? userdata->data() : STR_NULL);
}

YCR_RESPOND_TO("POST /users/$/data")
{
    auto uid = srv::positionalParam<srv::UserId>(argv, 0);
    srv::checkUid(uid);

    const auto& body = request.body();
    maps::json::Value::fromString(body); // validate json

    auto token = [&] {
        auto writeContext = srv::Globals::dbPools().writeContext();
        auto& socialTxn = writeContext.socialTxn();

        maps::wiki::social::Gateway gateway(socialTxn);
        gateway.setUserData(uid, body);

        return writeContext.commit();
    }();

    response << YCR_JSON(respBuilder) {
        respBuilder[STR_TOKEN] = token;
    };
}

} // YCR_USE
