#include <maps/wikimap/mapspro/services/social/src/libs/feedback-actions/meta.h>
#include <maps/libs/json/include/builder.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/consts.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/serialize.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/common.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/mv_source_type.h>

namespace maps::wiki::socialsrv {

namespace mwsf = social::feedback;

std::string feedbackMeta(IDbPools& dbPools)
{
    json::Builder builder;
    builder << [&](json::ObjectBuilder builder) {
        builder["typesCategorized"] << [&](json::ArrayBuilder builder) {
            jsonize(builder, mwsf::typeCategoryToTypes());
        };
        builder["pins"] << [&](json::ObjectBuilder builder) {
            builder["minZoomByStatus"] << [&](json::ObjectBuilder builder) {
                builder["opened"] << MIN_SCALE_TO_SHOW_PINS;
                builder["need-info"] << MIN_SCALE_TO_SHOW_PINS;
                builder["resolved"] << MIN_SCALE_TO_SHOW_CLOSED_PINS;
            };
        };
        builder["workflows"] << [&](json::ArrayBuilder builder) {
            socialsrv::collectionToJsonArray(builder, mwsf::allWorkflows());
        };
        builder["ageTypes"] << [&](json::ArrayBuilder builder) {
            socialsrv::collectionToJsonArray(builder, mwsf::allAgeTypes());
        };

        auto socialTxn = dbPools.socialReadTxn();
        builder["sources"] << [&](json::ArrayBuilder builder) {
            socialsrv::collectionToJsonArray(
                builder,
                mwsf::mvSourcesByFilter(*socialTxn, mwsf::MvSourceTypeFilter{}));
        };

        builder["rejectReasonsCategorized"] << [&](json::ObjectBuilder builder) {
            builder["redirect-to-content"] << [&](json::ArrayBuilder builder) {
                socialsrv::collectionToJsonArray(builder, REDIRECT_TO_CONTENT);
            };
            builder["redirect-to-platform"] << [&](json::ArrayBuilder builder) {
                socialsrv::collectionToJsonArray(builder, REDIRECT_TO_PLATFORM);
            };
            builder["redirect-to-other"] << [&](json::ArrayBuilder builder) {
                socialsrv::collectionToJsonArray(builder, REDIRECT_TO_OTHER);
            };
            builder["common"] << [&](json::ArrayBuilder builder) {
                socialsrv::collectionToJsonArray(builder, COMMON_REJECT_REASONS);
            };
        };
    };
    return builder.str();
}

} // namespace maps::wiki::socialsrv
