#pragma once

#include <maps/wikimap/mapspro/services/social/src/libs/common/db_pools.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/enums.h>

#include <string>

namespace maps::wiki::socialsrv {

std::string feedbackMeta(IDbPools& dbPools);

const social::feedback::RejectReasonsSet REDIRECT_TO_CONTENT {
    social::feedback::RejectReason::RedirectToContentAuto,
    social::feedback::RejectReason::RedirectToContentBicycle,
    social::feedback::RejectReason::RedirectToContentBigTask,
    social::feedback::RejectReason::RedirectToContentMasstransit,
    social::feedback::RejectReason::RedirectToContentOther,
    social::feedback::RejectReason::RedirectToContentPedestrian,
    social::feedback::RejectReason::RedirectToContentRoadEvents,
    social::feedback::RejectReason::RedirectToContentToponym,
    social::feedback::RejectReason::RedirectToContentTruck,
};

const social::feedback::RejectReasonsSet REDIRECT_TO_PLATFORM {
    social::feedback::RejectReason::RedirectToPlatformAuto,
    social::feedback::RejectReason::RedirectToPlatformBicycle,
    social::feedback::RejectReason::RedirectToPlatformMasstransit,
    social::feedback::RejectReason::RedirectToPlatformToponym,
    social::feedback::RejectReason::RedirectToPlatformTruck,
};

const social::feedback::RejectReasonsSet REDIRECT_TO_OTHER {
    social::feedback::RejectReason::RedirectToSprav,
    social::feedback::RejectReason::RedirectToSupport,
};

const social::feedback::RejectReasonsSet COMMON_REJECT_REASONS {
    social::feedback::RejectReason::IncorrectData,
    social::feedback::RejectReason::NoData,
    social::feedback::RejectReason::NoInfo,
    social::feedback::RejectReason::ProhibitedByRules,
    social::feedback::RejectReason::Spam,
};

} // namespace maps::wiki::socialsrv
