#pragma once

#include <maps/libs/json/include/value.h>
#include <maps/wikimap/mapspro/services/social/src/libs/common/common.h>
#include <maps/wikimap/mapspro/services/social/src/libs/common/db_pools.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/feed_for_ui.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/presets.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/caching_acl.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/feedback.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/common.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/preset.h>

namespace maps::wiki::socialsrv {

std::string createPreset(
    const maps::json::Value& jsonPreset,
    WriteContext&& writeContext
);

std::string updatePreset(
    social::TId presetId,
    const maps::json::Value& jsonPreset,
    WriteContext&& writeContext
);

std::string deletePreset(social::TId presetId, WriteContext&& writeContext);

AssignedPresetsResponse getAssignedPresetsResponse(
    pqxx::transaction_base& coreTxn,
    pqxx::transaction_base& socialTxn,
    const acl_utils::FeedbackPresetChecker& fbPresetChecker,
    UserId uid);

TaskFeedForUI getPresetsTasksFeed(
    pqxx::transaction_base& socialTxn,
    const acl_utils::FeedbackChecker& feedbackChecker,
    UserId uid,
    social::TId presetId,
    social::TId aoiId,
    const sf::TaskFeedParamsId& feedParams);

social::feedback::TaskFilter assignedPresetFilter(
    const sf::Preset& preset,
    social::TId aoiId);

namespace internal
{

social::feedback::PresetEntries presetEntriesFromJson(const json::Value& json);

} // namespace internal

} // namespace maps::wiki::socialsrv
