#pragma once

#include <maps/wikimap/mapspro/libs/acl_utils/include/feedback.h>
#include <maps/wikimap/mapspro/services/social/src/libs/common/common.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/feed_for_ui.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback-actions/tasks_helpers.h>
#include <yandex/maps/wiki/social/common.h>
#include <vector>

namespace maps::wiki::socialsrv {

struct TasksFeedParams
{
    ID beforeId = 0;
    ID afterId = 0;
    size_t perPage = 10;
    std::optional<bool> hidden;
    std::optional<social::feedback::UIFilterStatus> status;
    std::optional<bool> resolved;
    std::optional<std::vector<social::feedback::Type>> types;
    std::optional<ID> objectId;
    std::optional<std::string> bboxGeo;
    std::optional<social::TId> feedRegionId;
    std::optional<social::TUid> createdBy;
    std::optional<social::TUid> acquiredBy;
    std::optional<social::TUid> resolvedBy;
    bool resolvedByRobots = true;
    std::optional<std::vector<std::string>> sources;
    std::optional<std::vector<social::feedback::Workflow>> workflows;
    std::optional<social::TId> duplicateHeadId;
};

TaskFeedForUI getTasksFeed(
    DbPools& dbPools,
    const acl_utils::FeedbackChecker& feedbackChecker,
    const TasksFeedParams& params,
    social::TUid uid,
    const DbToken& token);

} // namespace maps::wiki::socialsrv
