#include "tasks_get.h"

#include <maps/wikimap/mapspro/services/social/src/libs/yacare/error.h>

#include <maps/wikimap/mapspro/libs/acl_utils/include/feedback.h>
#include <yandex/maps/wiki/social/feedback/gateway_ro.h>

namespace maps::wiki::socialsrv {

namespace mws = social;
namespace mwsf = social::feedback;

serialize::TaskExtended getTask(
    DbPools& dbPools,
    const acl_utils::FeedbackChecker& feedbackChecker,
    mws::TId taskId,
    mws::TUid uid,
    const DbToken& token)
{
    auto socialReadTxn = dbPools.socialReadTxn(token);
    auto coreReadTxn   = dbPools.coreReadTxn(token);
    mwsf::GatewayRO gatewayRo(*socialReadTxn);

    auto taskExtended = makeTaskExtended(
        gatewayRo.taskById(taskId),
        feedbackChecker,
        *coreReadTxn,
        *socialReadTxn,
        uid);
    requireRevealed(taskExtended.taskForUI);

    SOCIAL_REQUIRE(
        feedbackChecker.isAllowedToView(
            taskExtended.taskForUI,
            taskExtended.taskForUI.history(),
            uid),
        Forbidden,
        "Task with id " << taskExtended.taskForUI.id() << " is forbidden for user " << uid;
    );

    auto taskDuplicates = gatewayRo.tasksByFilter(
            mwsf::TaskFilter().duplicateHeadId(taskId));
    taskExtended.duplicatesCount = taskDuplicates.size();
    return taskExtended;
}

} // namespace maps::wiki::socialsrv
