#pragma once

#include <maps/wikimap/mapspro/services/social/src/libs/common/db_pools.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/presets.h>
#include <maps/wikimap/mapspro/services/social/src/libs/yacare/error.h>

#include <maps/wikimap/mapspro/libs/acl_utils/include/feedback.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/feedback.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/preset.h>
#include <maps/wikimap/mapspro/libs/social_serv_serialize/include/task_extended.h>

#include <yandex/maps/wiki/social/feedback/agent.h>
#include <yandex/maps/wiki/social/feedback/task.h>
#include <yandex/maps/wiki/social/feedback/task_new.h>

namespace maps::wiki::socialsrv {

template<typename T>
void requireExists(const std::optional<T>& task)
{
    SOCIAL_ASSERT(task, NotFound);
}

void requireRevealed(const social::feedback::Task& task);

template<typename T>
void requireVisible(const std::optional<T>& task)
{
    requireExists(task);
    requireRevealed(*task);
}

social::feedback::TaskForUpdate getTaskForUpdate(
    social::feedback::Agent& agent,
    social::TId taskId);

serialize::TaskExtended makeTaskExtended(
    std::optional<social::feedback::Task> task,
    const acl_utils::FeedbackChecker& feedbackChecker,
    pqxx::transaction_base& coreTxn,
    pqxx::transaction_base& socialTxn,
    social::TUid uid);

void checkPermissionForTask(
    const acl_utils::FeedbackChecker& feedbackChecker,
    social::TUid uid,
    const social::feedback::Task& task,
    const social::feedback::History& history,
    social::feedback::TaskOperation operation);

struct PostTaskResult
{
    serialize::TaskExtended taskExt;
    DbToken token;
};

PostTaskResult postNewTask(
    DbPools& dbPools,
    const social::feedback::TaskNew& newTask);

} // namespace maps::wiki::socialsrv
