#pragma once

#include <maps/libs/json/include/value.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/libs/tile/include/tile.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/feedback_preset_checker.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/task_filter.h>
#include <maps/wikimap/mapspro/services/social/src/libs/common/common.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback-actions/tasks_helpers.h>

#include <pqxx/pqxx>

namespace maps::wiki::socialsrv {

namespace sf = social::feedback;

sf::TaskFilter makeTaskFilter(
    const acl_utils::FeedbackChecker& feedbackChecker,
    UserId uid,
    tile::Zoom zoom,
    std::optional<sf::Types> typesRaw,
    std::optional<sf::Workflows> workflows,
    std::optional<std::vector<std::string>> sources,
    std::optional<bool> hidden);

void addFilterParams(
    sf::TaskFilter& filter,
    acl_utils::CachingAclChecker& aclChecker,
    UserId uid,
    const tile::Tile& tile,
    const std::optional<sf::UIFilterStatus>& uiFilterStatus,
    std::optional<sf::AgeTypes> ageTypes,
    std::optional<std::string> indoorLevel);

sf::TaskFilter makeTaskFilter(
    acl_utils::CachingAclChecker& aclChecker,
    UserId uid,
    const tile::Tile& tile,
    const social::feedback::Preset& preset,
    const social::TId aoiId,
    const std::optional<std::string>& indoorLevel,
    const std::optional<sf::UIFilterStatus>& uiFilterStatus);

std::string getPinsJsonString(
    const sf::TasksBriefResult& result,
    UserId uid,
    const tile::Tile& tile);

} // namespace maps::wiki::socialsrv
