#pragma once

#include <maps/libs/json/include/value.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/task_aoi.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/feed_for_ui.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/regions.h>

#include <pqxx/pqxx>

namespace maps::wiki::socialsrv {

std::map<ID, AoiRegion> aoiRegionsFromIds(
    pqxx::transaction_base& coreTxn,
    const std::set<ID>& aoiIds);

RegionsStatRows getRegionsStat(
    pqxx::transaction_base& coreTxn,
    std::function<pgpool3::TransactionHandle ()> socialHandleGetter,
    social::feedback::AoiTaskFilter filter);

AoiRegionToTaskCounters getRegionsCounters(
    pqxx::transaction_base& coreTxn,
    pqxx::transaction_base& socialTxn,
    UserId uid,
    const social::feedback::TaskFilter& filter);

TaskFeedForUI getRegionsFeed(
    pqxx::transaction_base& socialTxn,
    ID aoiId,
    const std::set<social::feedback::Partition> partitions,
    const social::feedback::TaskFilter& filter,
    const social::feedback::TaskFeedParamsId& feedParams,
    serialize::SubstitutionStrategy substitutionStrategy);

} // namespace maps::wiki::socialsrv
