#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/gateway_rw.h>
#include <maps/wikimap/mapspro/libs/unittest/include/yandex/maps/wiki/unittest/query_helpers_arcadia.h>
#include <maps/wikimap/mapspro/libs/unittest/include/yandex/maps/wiki/unittest/unittest.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback-actions/meta.h>
#include <maps/wikimap/mapspro/libs/social/tests/helpers/fb_task_creator.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/mv_source_type.h>

#include <maps/wikimap/mapspro/services/social/src/libs/test_helpers/helpers.h>
#include <library/cpp/testing/unittest/env.h>

namespace feedback = maps::wiki::social::feedback;

namespace maps::wiki::socialsrv::tests {

Y_UNIT_TEST_SUITE(feedback_actions_tests) {

Y_UNIT_TEST_F(action_meta, DbFixture) {
    {
        auto txnHandle = pool().masterWriteableTransaction();
        feedback::tests::FbTaskCreator(*txnHandle, feedback::TaskState::Accepted).create();
        feedback::refreshSourceTypeMv(*txnHandle);
        txnHandle->commit();
    }
    auto expectedBody = maps::json::Value::fromFile(SRC_("data/meta-response.json"));
    UNIT_ASSERT_VALUES_EQUAL(expectedBody, maps::json::Value::fromString(feedbackMeta(dbPools())));
}

}

} // namespace maps::wiki::socialsrv::tests
