#include <maps/wikimap/mapspro/services/social/src/libs/feedback/common.h>

#include <maps/wikimap/mapspro/services/social/src/libs/yacare/error.h>
#include <algorithm>

namespace maps::wiki::socialsrv {

namespace sf = social::feedback;

sf::Types typesIntersection(sf::Types lhs, sf::Types rhs)
{
    std::sort(lhs.begin(), lhs.end());
    std::sort(rhs.begin(), rhs.end());
    sf::Types res;
    std::set_intersection(
        lhs.begin(), lhs.end(),
        rhs.begin(), rhs.end(),
        std::back_inserter(res));
    return res;
}

void setStatusForPins(
    social::feedback::TaskFilter& filter,
    std::optional<social::feedback::UIFilterStatus> uiFilterStatus,
    tile::Zoom zoom)
{
    filter.uiFilterStatus(uiFilterStatus);
    /*
     * Idea here is not to show closed feedback on small scales
     * because number of closed feedback is much more than open one,
     * and it cat result in mess on frontend.
    */
    if (uiFilterStatus) {
        if (*uiFilterStatus == sf::UIFilterStatus::Resolved) {
            SOCIAL_ASSERT(zoom >= MIN_SCALE_TO_SHOW_CLOSED_PINS, NotFound);
        }
    } else {
        if (zoom < MIN_SCALE_TO_SHOW_CLOSED_PINS) {
            filter.resolved(false);
        }
    }
}

} // namespace maps::wiki::socialsrv
