#pragma once

#include <maps/libs/tile/include/tile.h>
#include <yandex/maps/wiki/social/feedback/enums.h>
#include <yandex/maps/wiki/social/feedback/task_filter.h>
#include <string>

namespace maps::wiki::socialsrv {

const int MIN_SCALE_TO_SHOW_PINS = 7;
const int MIN_SCALE_TO_SHOW_CLOSED_PINS = 18;

const std::string CLOSE_TASK_PERMISSION = "mpro/social/feedback/task/close";
const std::string HIDDEN_TASK_PERMISSION = "mpro/social/feedback/task/hidden";
const std::string TASK_FBAPI_ISSUE_ID_PERMISSION = "mpro/social/feedback/task/fbapi-task-id";
const std::string INTERNAL_CONTENT_TASK_PERMISSION = "mpro/mrc/photos/view-hidden";
const std::string NEED_INFO_TASK_PERMISSION = "mpro/social/feedback/task/need-info";
const std::string CHANGE_TYPE_TASK_PERMISSION = "mpro/social/feedback/task/change-type";
const std::string CHANGE_POSITION_TASK_PERMISSION = "mpro/social/feedback/task/change-position";
const std::string RESOLVE_TASK_PERMISSION = "mpro/social/feedback/task/resolve";
const std::string TASK_REJECT_REASON_PERMISSION = "mpro/social/feedback/task/reject-reason";
const std::string SOURCE_PERMISSION = "mpro/social/feedback/task/source";
const std::string PROCESSING_LVL1_PERMISSION = "mpro/social/feedback/task/processing-levels/1";
const std::string FEEDBACK_GROUP_REJECT = "mpro/tools/group-operations/reject-feedback";
const std::string PAID_OPERATIONS_COUNTER_PERMISSION = "mpro/social/feedback/paid-operations-counter";
const std::string FEEDBACK_REVIEW_PERMISSION_VIEW = "mpro/social/feedback/review/view";
const std::string FEEDBACK_REVIEW_PERMISSION_EDIT = "mpro/social/feedback/review/edit";

namespace jsids {

const std::string ID = "id";
const std::string AGE_TYPE = "ageType";
const std::string AGE_TYPES = "ageTypes";
const std::string SOURCE = "source";
const std::string SOURCES = "sources";
const std::string TYPE = "type";
const std::string TYPES = "types";
const std::string CATEGORY = "category";
const std::string WORKFLOW = "workflow";
const std::string WORKFLOWS = "workflows";
const std::string POSITION = "position";
const std::string INDOOR_LEVEL = "indoorLevel";
const std::string DESCRIPTION = "description";
const std::string RESOLVED = "resolved";
const std::string STATUS = "status";
const std::string RESOLUTION = "resolution";
const std::string HIDDEN = "hidden";
const std::string INTERNAL_CONTENT = "internalContent";
const std::string OBJECT_ID = "objectId";
const std::string TOKEN = "token";
const std::string FEEDBACK_TASK = "feedbackTask";
const std::string FEEDBACK_PRESET = "feedbackPreset";
const std::string TASK_COUNT = "taskCount";
const std::string TASK_VIEWED_COUNT = "taskViewedCount";
const std::string TASK_BOUNDS = "taskBounds";
const std::string SUMMARY = "summary";
const std::string TASKS = "tasks";
const std::string HAS_MORE = "hasMore";
const std::string TOTAL_COUNT = "totalCount";
const std::string FEEDBACK_TYPE = "feedbackType";
const std::string USER_ATTRS = "userAttrs";
const std::string TRACK_COUNT = "trackCount";
const std::string PROBABILITY = "probability";
const std::string EXPECTED_TRACK_RIPS = "expectedTrackRips";
const std::string BBOX = "bbox";
const std::string POINTS = "points";
const std::string POLYLINES = "polylines";
const std::string PATH = "path";
const std::string MOVEMENT = "movement";
const std::string NAME = "name";
const std::string PAID_OPERATION_COUNTERS = "paidOperationCounters";
const std::string TODAY = "today";

} // namespace jsids

social::feedback::Types
typesIntersection(
    social::feedback::Types lhs,
    social::feedback::Types rhs);

void setStatusForPins(
    social::feedback::TaskFilter& filter,
    std::optional<social::feedback::UIFilterStatus> uiFilterStatus,
    tile::Zoom zoom);

} // namespace maps::wiki::socialsrv
