#include <maps/wikimap/mapspro/services/social/src/libs/feedback/presets.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/serialize.h>

namespace maps::wiki::socialsrv {

AssignedPresetsResponse::AssignedPresetsResponse(
    std::vector<AssignedPresetWithCounter>&& assignedPresets,
    std::map<social::TId, sf::Preset>&& presets,
    std::map<social::TId, AoiRegion>&& aois)
    : assignedPresets_(assignedPresets)
    , presets_(presets)
    , aois_(aois)
{
}

const std::vector<AssignedPresetWithCounter>& AssignedPresetsResponse::assignedPresets() const
{
    return assignedPresets_;
}

const std::map<social::TId, sf::Preset>& AssignedPresetsResponse::presets() const
{
    return presets_;
}

const std::map<social::TId, AoiRegion>& AssignedPresetsResponse::aois() const
{
    return aois_;
}

} // namespace maps::wiki::socialsrv
