#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/aoi.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/preset.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/regions.h>

#include <map>
#include <vector>

namespace maps::wiki::socialsrv {

namespace sf = social::feedback;

struct AssignedPresetWithCounter
{
    social::TId presetId;
    social::TId aoiId;
    uint64_t totalOpened;
};

class AssignedPresetsResponse
{
public:
    AssignedPresetsResponse(
        std::vector<AssignedPresetWithCounter>&& assignedPresets,
        std::map<social::TId, sf::Preset>&& presets,
        std::map<social::TId, AoiRegion>&& aois);

    const std::vector<AssignedPresetWithCounter>& assignedPresets() const;
    const std::map<social::TId, sf::Preset>& presets() const;
    const std::map<social::TId, AoiRegion>& aois() const;

private:
    std::vector<AssignedPresetWithCounter> assignedPresets_;
    std::map<social::TId, sf::Preset> presets_;
    std::map<social::TId, AoiRegion> aois_;
};

} // namespace maps::wiki::socialsrv
