#pragma once

#include <maps/infra/yacare/include/request.h>
#include <maps/wikimap/mapspro/services/social/src/libs/common/common.h>
#include <yandex/maps/wiki/social/feedback/task.h>
#include <yandex/maps/wiki/social/feedback/task_aoi.h>
#include <map>
#include <optional>

namespace maps::wiki::socialsrv {

struct AoiRegion
{
    AoiRegion(ID aoiId, std::string title);

    ID aoiId;
    std::string title;
};

bool operator < (const AoiRegion& lhs, const AoiRegion& rhs);

using AoiRegionToTaskCounters =
    std::map<AoiRegion, social::feedback::AoiTaskCounters>;


struct RegionStatRow
{
    RegionStatRow(
        const AoiRegion& region,
        const social::feedback::AoiTaskStatCounters& counters,
        const std::optional<social::feedback::Task>& oldestTask);

    AoiRegion region;
    social::feedback::AoiTaskStatCounters counters;
    std::optional<social::feedback::Task> oldestTask;
};

using RegionsStatRows = std::map<ID, RegionStatRow>;

} // namespace maps::wiki::socialsrv
