#pragma once

#include "review_utils.h"
#include <yandex/maps/wiki/social/feedback/review.h>

#include <maps/libs/common/include/temporary_dir.h>
#include <maps/libs/json/include/value.h>
#include <yandex/maps/mds/mds.h>
#include <library/cpp/tvmauth/client/facade.h>

#include <functional>
#include <string>

namespace maps::wiki::socialsrv {

using TranslationProvider = std::function<std::string(const std::string&, const std::string&)>;
using ImageProvider = std::function<std::string(std::string)>;

std::string
makeHtmlReport(
    const social::feedback::Review& review,
    const ReviewExternData& reviewExternData,
    TranslationProvider translationProvider,
    ImageProvider imageProvider);

struct MrcImageInfo
{
    std::string imageId;
    std::string downloadUrl;
};

MrcImageInfo
getMrcImageInfo(
    const std::string& inputFeedbackUrl,
    const std::string& mrcBrowserUrl);

std::string
downloadMrcImage(
    const std::string& imageUrl,
    const std::string& mrcBrowserUrl,
    const std::string& ticket,
    const maps::common::TemporaryDir& tempDir);

std::string
convertHtmlToPdf(
    const std::string& htmlContent,
    const maps::common::TemporaryDir& tempDir);

std::string
makePdfReportAndUpload(
    const social::feedback::Review& review,
    const ReviewExternData& reviewExternData,
    const std::string& lang,
    const json::Value& translations,
    const NTvmAuth::TTvmClient& tvmClient,
    const mds::Configuration& mdsConfig,
    const std::string& mrcBrowserUrl);

} // namespace maps::wiki::socialsrv
