#pragma once

#include <yandex/maps/wiki/social/feedback/review.h>
#include <yandex/maps/wiki/social/feedback/task.h>
#include <maps/wikimap/mapspro/libs/social_serv_serialize/include/task_for_review_ui.h>

#include <string>

using namespace maps::wiki::social;

namespace maps::wiki::socialsrv {

enum class IncludeTasksWithoutComments
{
    Yes,
    No
};

struct RegionData
{
    TId id;
    TId commitId;
    std::string categoryId;
    std::string title;
    TUid pedestrianUid;
    std::string pedestrianLogin;
    geolib3::Polygon2 polygon;
};

RegionData
getRegionData(
    pqxx::transaction_base& coreTxn,
    TId id,
    TId commitId = 0);

struct ReviewExternData
{
    RegionData region;
    serialize::TasksForReviewUI tasks;
};

ReviewExternData
getReviewExternData(
    const feedback::Review& review,
    pqxx::transaction_base& coreReadTxn,
    pqxx::transaction_base& socialReadTxn,
    IncludeTasksWithoutComments includeWithoutComments = IncludeTasksWithoutComments::Yes);

void updateReviewFromJson(feedback::Review& review, const std::string& updateReviewJson);
} // namespace maps::wiki::socialsrv
