#include <library/cpp/testing/unittest/registar.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/description.h>
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::socialsrv::tests {

Y_UNIT_TEST_SUITE(feedback_description) {

Y_UNIT_TEST(route_gap_description_regular)
{
    UNIT_ASSERT_STRINGS_EQUAL(
        constructRouteGapDescrLink(
            geolib3::BoundingBox(
                {37.005661, 55.508978},
                {37.008739, 55.511189}
            ),
            std::vector<geolib3::Point2>({
                {37.006161, 55.509478},
                {37.008239, 55.510689}
            }),
            std::vector<geolib3::Polyline2>({
                geolib3::Polyline2(
                    geolib3::PointsVector({
                        {37.000921, 55.512584},
                        {37.001954, 55.512008}
                    })
                ),
                geolib3::Polyline2(),
                geolib3::Polyline2(
                    geolib3::PointsVector({
                        {37.002044, 55.511921},
                        {37.007404, 55.508815},
                        {37.009650, 55.511701}
                    })
                )
            })
        ),
        "https://static-maps.yandex.ru/1.x/?l=map"
        "&bbox=37.005661,55.508978~37.008739,55.511189"
        "&pt=37.006161,55.509478,pm2am~37.008239,55.510689,pm2bm"
        "&pl=c:0c923bC0,w:3,37.000921,55.512584,37.001954,55.512008~"
            "c:0c4492C0,w:3,37.002044,55.511921,37.007404,55.508815,37.009650,55.511701"
        "&size=650,450"
    );
}

Y_UNIT_TEST(route_gap_description_few_points)
{
    UNIT_ASSERT_EXCEPTION(
        constructRouteGapDescrLink(
            geolib3::BoundingBox(
                {1, 2}, {3, 4}
            ),
            std::vector<geolib3::Point2>({
                {5, 6}
            }),
            std::vector<geolib3::Polyline2>({
                geolib3::Polyline2(),
            })
        ),
        RuntimeError
    );
}

Y_UNIT_TEST(route_gap_description_too_many_polylines)
{
    UNIT_ASSERT_EXCEPTION(
        constructRouteGapDescrLink(
            geolib3::BoundingBox(
                {1, 2}, {3, 4}
            ),
            std::vector<geolib3::Point2>({
                {5, 6}, {7, 8}
            }),
            std::vector<geolib3::Polyline2>(6, geolib3::Polyline2())
        ),
        RuntimeError
    );
}

Y_UNIT_TEST(route_gap_description_few_points_in_polyline)
{
    UNIT_ASSERT_EXCEPTION(
        constructRouteGapDescrLink(
            geolib3::BoundingBox(
                {1, 2}, {3, 4}
            ),
            std::vector<geolib3::Point2>({
                {5, 6}, {7, 8}
            }),
            std::vector<geolib3::Polyline2>({
                geolib3::Polyline2({geolib3::Point2(1, 2)})
            })
        ),
        RuntimeError
    );
}

Y_UNIT_TEST(prohibited_path_description)
{
    const std::string result = constructProhibitedPathDescrLink(
        geolib3::Polyline2(
            geolib3::PointsVector{{0.0, 3.0}, {1.1, 1.5}}
        )
    );

    const std::string expected = "https://static-maps.yandex.ru/1.x/?l=map&pl=c:cc0000,w:3,0.00000000,3.00000000,1.10000000,1.50000000&pt=0.00000000,3.00000000,ya_ru~1.10000000,1.50000000,flag";

    UNIT_ASSERT_STRINGS_EQUAL(result, expected);
}

} // Y_UNIT_TEST_SUITE(feedback_description)

} // namespace maps::wiki::socialsrv::tests
