#include <maps/wikimap/mapspro/libs/social_serv_serialize/include/jsonize_feedback_task.h>
#include <maps/libs/json/include/builder.h>

#include <yandex/maps/wiki/unittest/json_schema.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/env.h>

namespace maps::wiki::socialsrv::tests {

namespace {

void checkContext(
    const std::string& oldStr,
    const std::string& expectedStr,
    const std::string& schemaPath)
{
    auto oldContext = json::Value::fromString(oldStr);
    auto newContext = serialize::transformSourceContext(oldContext);
    auto expectedContext = json::Value::fromString(expectedStr);

    EXPECT_EQ(newContext, expectedContext);

    json::Builder builder;
    builder << newContext;
    wiki::unittest::validateJson(builder.str(), schemaPath);
}

} // namespace

Y_UNIT_TEST_SUITE(feedback_context) {

Y_UNIT_TEST(test_transform_mrc_context)
{
    const std::string MRC_OLD_CONTEXT_STR = R"({
        "features":[{
            "box":[1415,107,1576,268],
            "geometry":{"coordinates":[49.0919256862253,55.82289299926379],"type":"Point"},
            "heading":242.18,
            "id":"13676451",
            "imageFull":{"height":1080,"url":"https://mrc-browser.maps.yandex.net/feature/13676451/image","width":1920},
            "imagePreview":{"height":160,"url":"https://mrc-browser.maps.yandex.net/feature/13676451/thumbnail","width":284},
            "timestamp":"2017-12-16T10:46:39"
        }],
        "id":"31727",
        "sign":{
            "geometry":{"coordinates":[49.09186564828082,55.823000608030384],"type":"Point"},
            "heading":61.43,"id":"31727",
            "type":"prohibitory_no_parking"
        },
        "type":"absent_parking"
    })";

    const std::string MRC_NEW_CONTEXT_STR = R"({
        "type":"mrc",
        "content":{
            "imageFeatures":[{
                "box":[1415,107,1576,268],
                "geometry":{"coordinates":[49.0919256862253,55.82289299926379],"type":"Point"},
                "heading":242.18,
                "id":"13676451",
                "imageFull":{"height":1080,"url":"https://mrc-browser.maps.yandex.net/feature/13676451/image","width":1920},
                "imagePreview":{"height":160,"url":"https://mrc-browser.maps.yandex.net/feature/13676451/thumbnail","width":284},
                "timestamp":"2017-12-16T10:46:39"
            }],
            "id":"31727",
            "sign":{
                "geometry":{"coordinates":[49.09186564828082,55.823000608030384],"type":"Point"},
                "heading":61.43,"id":"31727",
                "type":"prohibitory_no_parking"
            },
            "type":"absent_parking"
        }
    })";

    const std::string MRC_SCHEMA_PATH =
        ArcadiaSourceRoot() + "/maps/wikimap/mapspro/schemas/social/source_contexts/mrc_context.schema.json";

    EXPECT_NO_THROW(checkContext(MRC_OLD_CONTEXT_STR, MRC_NEW_CONTEXT_STR, MRC_SCHEMA_PATH));
}

Y_UNIT_TEST(test_transform_images_context)
{
    const std::string IMAGES_CONTEXT_STR = R"({
        "type":"images",
        "content":{
            "imageFeatures":[{
                "geometry":{"coordinates":[49.0919256862253,55.82289299926379],"type":"Point"},
                "heading":242.18,
                "id":"13676451",
                "imageFull":{"height":1080,"url":"https://mrc-browser.maps.yandex.net/feature/13676451/image","width":1920},
                "imagePreview":{"height":160,"url":"https://mrc-browser.maps.yandex.net/feature/13676451/thumbnail","width":284},
                "timestamp":"2017-12-16T10:46:39"
            }]
        }
    })";

    const std::string IMAGES_SCHEMA_PATH =
        ArcadiaSourceRoot() + "/maps/wikimap/mapspro/schemas/social/source_contexts/images_context.schema.json";

    EXPECT_NO_THROW(checkContext(IMAGES_CONTEXT_STR, IMAGES_CONTEXT_STR, IMAGES_SCHEMA_PATH));
}

} // Y_UNIT_TEST_SUITE

} //namespace maps::wiki::socialsrv::tests
