#include "user_processing_level.h"

#include "common.h"

#include <yandex/maps/wiki/social/feedback/consts.h>

namespace maps::wiki::socialsrv {

namespace sf = social::feedback;

using serialize::SubstitutionStrategy;

namespace {

int getUserProcessingLevel(
    acl_utils::CachingAclChecker& aclChecker, acl::UID uid)
{
    if (aclChecker.userHasPermission(uid, PROCESSING_LVL1_PERMISSION)) {
        return sf::PROCESSING_LEVEL_MIN + 1;
    } else {
        return sf::PROCESSING_LEVEL_MIN;
    }
}

} // namespace

SubstitutionStrategy getSubstitutionStrategy(
    acl_utils::CachingAclChecker& aclChecker, acl::UID uid)
{
    if (getUserProcessingLevel(aclChecker, uid) > sf::PROCESSING_LEVEL_MIN) {
        return SubstitutionStrategy::None;
    } else {
        return SubstitutionStrategy::ForZeroProcessingLine;
    }
}

} // namespace maps::wiki::socialsrv
