#include "profile_ui.h"

#include <maps/libs/chrono/include/days.h>

namespace maps::wiki::socialsrv {

namespace {

const std::string ABOUT = "about";
const std::string EMAIL = "email";
const std::string LOCALE = "locale";
const std::string BROADCAST_SUBSCRIPTION = "broadcastSubscription";
const std::string NEWS_SUBSCRIPTION = "newsSubscription";
const std::string SHOW_NEWS_SUBSCRIPTION_PROMPT = "showNewsSubscriptionPrompt";

} // anon namespace

ProfileUI::ProfileUI(
    const std::optional<social::Profile>& profile,
    const social::Prompts& prompts)
{
    if (profile) {
        std::for_each(
            prompts.begin(),
            prompts.end(),
            [&](const auto& prompt) { ASSERT(prompt.uid == profile->uid()); }
        );
    }

    auto showNewPrompt = [](const social::Prompts& prompts) {
        return
            prompts.empty() ||
            (
                prompts.size() == 1 &&
                prompts.front().processedAt <
                    chrono::TimePoint::clock::now() - chrono::Days{31}
            );
    };

    if (profile) {
        about = profile->about();
        email = profile->email();
        locale = profile->locale();
        broadcastSubscription = profile->hasBroadcastSubscription();
        newsSubscription = profile->hasNewsSubscription();
    }

    showNewsSubscriptionPrompt = !newsSubscription && showNewPrompt(prompts);
}

void json(const ProfileUI& profile, json::ObjectBuilder builder)
{
    builder[ABOUT] = profile.about;
    builder[EMAIL] = profile.email;
    builder[LOCALE] = profile.locale;
    builder[BROADCAST_SUBSCRIPTION] = profile.broadcastSubscription;
    builder[NEWS_SUBSCRIPTION] = profile.newsSubscription;
    builder[SHOW_NEWS_SUBSCRIPTION_PROMPT] = profile.showNewsSubscriptionPrompt;
}

} // namespace maps::wiki::socialsrv
