#pragma once

#include <yandex/maps/wiki/social/profile.h>
#include <yandex/maps/wiki/social/prompt.h>
#include <maps/libs/json/include/builder.h>

namespace maps::wiki::socialsrv {

struct ProfileUI
{
    ProfileUI() = default;

    ProfileUI(
        const std::optional<social::Profile>& profile,
        const social::Prompts& prompts);

    std::string about{};
    std::string email{};
    std::string locale{};
    bool broadcastSubscription{true};
    bool newsSubscription{false};
    bool showNewsSubscriptionPrompt{true};
};

void json(const ProfileUI& profile, json::ObjectBuilder builder);

} // namespace maps::wiki::socialsrv
