#include "rating_common.h"

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::wiki::socialsrv {

namespace {

constexpr maps::enum_io::Representations<RatingType> RATING_TYPE_ENUM_REPRESENTATION {
    {RatingType::Full, "full"},
    {RatingType::Quarter, "quarter"},
    {RatingType::Month, "month"},
    {RatingType::Week, "week"},
    {RatingType::Day, "day"}
};

} // namespace

DEFINE_ENUM_IO(RatingType, RATING_TYPE_ENUM_REPRESENTATION);

size_t getRatingPos(
        pqxx::transaction_base& txn,
        RatingType ratingType,
        UserId userId)
{
    // N.B.: using V2 version of rating
    //
    auto tableName = "rating." + std::string(toString(ratingType)) + "_v2";

    auto posRows = txn.exec(
        "SELECT COALESCE("
            " (SELECT pos FROM " + tableName +
                " WHERE uid = " + std::to_string(userId) + "),"
            " max(pos) + 1, 1)"
        " FROM " + tableName);
    ASSERT(posRows.size() == 1);

    return posRows[0][0].as<size_t>();
}

} // namespace maps::wiki::socialsrv
