#pragma once

#include <cstddef>

namespace maps {
namespace wiki {
namespace socialsrv {

// Calculates appropriate data window for 'infinite scroll' UI block.
//
// Given window size and total entries count, computes offset and number
// of elements to be displayed to satisfy requested anchor position alignment.
class ScrollWindow
{
public:
    enum class Align
    {
        Center,
        Left,
        Right
    };

    ScrollWindow();
    ScrollWindow(size_t size, size_t total, size_t anchor, Align align);

    size_t offset() const;
    size_t count() const;

    bool hasBefore() const;
    bool hasAfter() const;

private:
    size_t offset_;
    size_t count_;
    size_t total_;
};

} // namespace socialsrv
} // namespace wiki
} // namespace maps
