#include <maps/wikimap/mapspro/services/social/src/libs/test_helpers/helpers.h>
#include <maps/libs/json/include/value.h>
#include <regex>

template <>
void Out<maps::json::Value>(
    IOutputStream& os,
    const maps::json::Value& json)
{
    std::ostringstream ostr;
    ostr << json;
    os << ostr.str();
}

namespace maps::wiki::socialsrv::tests {

WriteContext DbFixture::writeContext()
{
    return { pool().masterWriteableTransaction(), pool().masterWriteableTransaction() };
}

pgpool3::TransactionHandle DbFixture::coreReadTxn(const DbToken&)
{
    return pool().slaveTransaction();
}

pgpool3::TransactionHandle DbFixture::socialReadTxn(const DbToken&)
{
    return pool().slaveTransaction();
}

pgpool3::TransactionHandle DbFixture::viewTrunkTxn()
{
    return pool().slaveTransaction();
}

std::string censorToken(const std::string& str)
{
    return std::regex_replace(
        str,
        std::regex{R"/("token":"\d*:\d:core\.\d*:\d:social")/"},
        std::string{R"("token":"123:1:core.321:2:social")"});
}

} // namespace maps::wiki::socialsrv::tests
