#pragma once

#include <maps/wikimap/mapspro/libs/unittest/include/yandex/maps/wiki/unittest/arcadia.h>
#include <maps/wikimap/mapspro/services/social/src/libs/common/db_pools.h>

template <>
void Out<maps::json::Value>(
    IOutputStream& os,
    const maps::json::Value& json);

namespace maps::wiki::socialsrv::tests {

class DbFixture: public unittest::ArcadiaDbFixture, protected IDbPoolsWithViewTrunk
{
public:
    DbFixture() = default;

    IDbPoolsWithViewTrunk& dbPools() { return *this; }

    ///
    /// IDbPoolsWithViewTrunk
    ///

    WriteContext writeContext() override;
    pgpool3::TransactionHandle coreReadTxn(const DbToken&) override;
    pgpool3::TransactionHandle socialReadTxn(const DbToken&) override;
    pgpool3::TransactionHandle viewTrunkTxn() override;
};

std::string censorToken(const std::string& str);

} // namespace maps::wiki::socialsrv::tests
