#include "bbox.h"

#include "error.h"
#include <maps/libs/common/include/exception.h>
#include <yandex/maps/wiki/common/geom_utils.h>

#include <sstream>

namespace maps::wiki::socialsrv {

geolib3::BoundingBox bboxGeoFromRequest(const std::string& requestStr)
{
    try {
        return common::bboxFromCommaSeparatedCoords(requestStr);
    } catch (const std::exception& e) {
        throw yacare::errors::BadRequest()
            << "Can not convert comma separated value '"
            << requestStr << "' to bbox: " << e.what();
    }
}

} // namespace maps::wiki::socialsrv
