#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/exception_info.h>
#include <maps/infra/yacare/include/error.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

namespace yacare {

class Request;

} // namespace yacare

namespace maps::wiki::socialsrv {

class Error : public yacare::Error
{
public:
    enum class Status {
        AssessmentLimitExceeded,
        ContentTooLarge,
        Duplicate,
        FeedbackResolveLimitExceeded,
        Forbidden,
        InvalidOperation,
        NotFound,
        PresetDuplicate,
        PresetNotFound,
        PresetsLimitExceed,
    };

    explicit Error(Status);
    ~Error() { };
    virtual void raise() const { throw *this; }
    virtual void format(yacare::Response&) const;
    Status status() const { return status_; }

private:
    Status status_;
};

DECLARE_ENUM_IO(Error::Status);

void errorReporter(const yacare::Request&, yacare::Response&);

#define SOCIAL_ASSERT(cond, status) \
    if (Y_LIKELY(cond)) {} else throw Error(Error::Status::status)

#define SOCIAL_REQUIRE(cond, status, msg) \
    if (Y_LIKELY(cond)) {} else throw Error(Error::Status::status) << msg


controller::ExceptionInfo handleException();

} // namespace maps::wiki::socialsrv
