#pragma once

#include "jsonize_events.h"

#include <maps/wikimap/mapspro/services/social/src/libs/common/db_pools.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/cached_moderation_statuses.h>
#include <maps/libs/tile/include/tile.h>

#include <yandex/maps/wiki/configs/editor/config_holder.h>

#include <optional>
#include <vector>

namespace maps::wiki::socialsrv {

social::TUids getIngnoredUids(
    const std::optional<std::vector<std::string>>& skipCreatedBy,
    acl::UID uid,
    const acl_utils::UserGroupsUidsCache& uidsCache);

std::list<EventData> getEventsForTile(
    IDbPools& dbPools,
    const configs::editor::ConfigHolder& editorConfig,
    const tile::Tile& tile,
    size_t limit,
    social::TUids skippedUids,
    const std::string& token);

} // namespace maps::wiki::socialsrv
