#pragma once

#include "sprav.h"

#include <maps/wikimap/mapspro/services/social/src/libs/common/db_pools.h>

#include <maps/libs/geolib/include/point.h>

#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/common.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/enums.h>
#include <optional>
#include <vector>

namespace maps::wiki::socialsrv {

struct PoiData {
    social::TId objectId;
    geolib3::Point2 positionMercator;
};

struct BusinessData : public PoiData
{
    social::feedback::Type feedbackType = social::feedback::Type::Poi;
};

struct CompanyData {
    BusinessData business;
    std::vector<PoiData> entrances;
};

// with autodetect business.feedbackType
std::optional<CompanyData> findCompany(
    DbPoolsWithViewTrunk& dbPools,
    const SpravData& spravData,
    double distance);

// without autodetect business.feedbackType
std::optional<CompanyData> findCompanyByObjectId(
    DbPoolsWithViewTrunk& dbPools,
    social::TId objectId);

} // namespace maps::wiki::socialsrv
