#pragma once

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geosearch_client/include/client.h>

#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/common.h>
#include <optional>
#include <set>

namespace maps::wiki::socialsrv {

struct SpravData {
    social::TId businessId;
    geolib3::Point2 positionGeo;
    std::set<social::TId> clusterPermalinkIds;
    std::set<social::TId> objectIds;
};

std::optional<SpravData> loadSpravData(
    geosearch_client::Client& geosearchClient,
    social::TId businessId);

} // namespace maps::wiki::socialsrv
