#include "yacare.h"
#include <maps/wikimap/mapspro/services/social/src/libs/yacare/error.h>

namespace maps::wiki::socialsrv {

std::string getSyncTokenFromHeader(const yacare::Request& request)
{
    return request.env("HTTP_X_YA_SYNC_TOKEN");
}

void setSyncTokenHeader(yacare::Response& response, const std::string& token)
{
    response.setHeader("X-Ya-Sync-Token", token);
}

void catchAllErrors(yacare::Response& response, std::string_view context)
{
    try {
        throw;
    } catch (const socialsrv::Error& ex) {
        ERROR() << context << " status: " << ex.status() << " : " << ex.what();
        switch (ex.status()) {
            case socialsrv::Error::Status::Forbidden:
                response << (yacare::errors::Forbidden() << ex.what());
                break;
            case socialsrv::Error::Status::NotFound:
                response << (yacare::errors::NotFound() << ex.what());
                break;
            case socialsrv::Error::Status::Duplicate:
                response << (yacare::errors::Conflict() << ex.what());
                break;
            default:
                response << (yacare::errors::InternalError() << ex.what());
                break;
        }
    } catch (const yacare::Error& ex) {
        ERROR() << context << " http status: " << ex.status() << " : " << ex.what();
        response << ex;
    } catch (const std::exception& ex) {
        ERROR() << context << " : " << ex.what();
        response << (yacare::errors::InternalError() << ex.what());
    }
}

} // namespace maps::wiki::socialsrv
