#pragma once

#include <maps/infra/yacare/include/yacare.h>

YCR_QUERY_CUSTOM_PARAM((), externalReferenceId, std::string)
{
    const auto& id = request.input()["id"];
    REQUIRE(!id.empty(), yacare::errors::BadRequest() << "Empty id");
    dest = id;
    return true;
}

namespace maps::wiki::socialsrv {

std::string getSyncTokenFromHeader(const yacare::Request& request);

void setSyncTokenHeader(yacare::Response& response, const std::string& token);

void catchAllErrors(yacare::Response& response, std::string_view context);

} // namespace maps::wiki::socialsrv
