#include <maps/wikimap/mapspro/services/tasks-ng/lib/config.h>
#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/common/default_config.h>

namespace maps {
namespace wiki {
namespace tasks_ng {

const std::string GRINDER_HOST = "/config/common/grinder/host";
const std::string LOG_LEVEL = "/config/log/level";
const log8::Level DEFAULT_LOG_LEVEL = log8::Level::INFO;

namespace {
std::unique_ptr<Config> config;

std::unique_ptr<common::ExtendedXmlDoc> getDoc(const std::string& filename)
{
    if (filename.empty()) {
        INFO() << "Using default config";
        return common::loadDefaultConfig();
    }
    INFO() << "Using config: " << filename;
    return std::make_unique<common::ExtendedXmlDoc>(filename);
}

} // namespace

Config::Config(const std::string& filename)
    : doc_(getDoc(filename))
    , grinderHost_(get<std::string>(GRINDER_HOST))
{
    log8::setLevel(get<log8::Level>(LOG_LEVEL, DEFAULT_LOG_LEVEL));
}

ConfigScope::ConfigScope(const std::string& fileName)
{
    config = std::make_unique<Config>(fileName);
}

ConfigScope::~ConfigScope()
{
    config.reset();
}

const Config& cfg()
{
    ASSERT(config);
    return *config;
}

} // namespace tasks_ng
} // namespace wiki
} // namespace maps
