#pragma once

#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <memory>

namespace maps {
namespace wiki {
namespace tasks_ng {

class Config
{
public:
    explicit Config(const std::string& fileName);

    template <typename ResultType>
    ResultType get(const std::string& path) const {
        return doc().get<ResultType>(path);
    }

    template <typename ResultType>
    ResultType get(const std::string& path, const ResultType& defaultValue) const {
        return doc().get<ResultType>(path, defaultValue);
    }

    const wiki::common::ExtendedXmlDoc& doc() const { return *doc_; }
    const std::string& grinderHost() const { return grinderHost_; }

private:
    std::unique_ptr<common::ExtendedXmlDoc> doc_;
    std::string grinderHost_;
};

const Config& cfg();

class ConfigScope
{
public:
    explicit ConfigScope(const std::string& filename);
    ~ConfigScope();
};

} // namespace tasks_ng
} // namespace wiki
} // namespace maps
