#pragma once

#include <maps/libs/pgpool/include/pgpool3.h>
#include <memory>

namespace maps {
namespace wiki {
namespace tasks_ng {

enum class TokenPolicy { Generate, Skip };

class DbContext
{
public:
    pqxx::transaction_base& txnCore();

    std::string commit(TokenPolicy tokenPolicy);

    void commit() { commit(TokenPolicy::Skip); }

    static DbContext toRead(const std::string& token);
    static DbContext toWrite();

private:
    enum class AccessMode { ReadWrite, ReadOnly };

    explicit DbContext(AccessMode accessMode);

    AccessMode accessMode_;
    std::unique_ptr<pgpool3::TransactionHandle> workCore_;
};

} // namespace tasks_ng
} // namespace wiki
} // namespace maps


