#include <maps/wikimap/mapspro/services/tasks-ng/lib/db_pools.h>

#include <maps/libs/common/include/exception.h>
#include <memory>

namespace maps {
namespace wiki {
namespace tasks_ng {

namespace {
const std::string CONFIG_CORE = "core";

std::unique_ptr<DbPools> dbPools;
}


DbPools::DbPools(const Config& config)
    : core_(config.doc(), CONFIG_CORE, CONFIG_CORE)
{}

DbPools& DbPools::get()
{
    ASSERT(dbPools);
    return *dbPools;
}

void DbPools::init(const Config& config)
{
    ASSERT(!dbPools);
    dbPools.reset(new DbPools(config));
}

void DbPools::destroy()
{
    dbPools.reset();
}

} // namespace tasks_ng
} // namespace wiki
} // namespace maps
