#include <maps/wikimap/mapspro/services/tasks-ng/lib/exception.h>

namespace maps {
namespace wiki {
namespace tasks_ng {

namespace {

const std::string ERROR = "error";
const std::string STATUS = "STATUS";

} // namespace

void makeResponseError(
    XmlResponseWrapper& wrapper, const std::string& status, const std::string& what)
{
    auto& writer = wrapper.writer();

    wrapper.write([&] {
        writer.addTag(ERROR, [&] {
            writer
                .addAttribute(STATUS, status)
                .addCdata(what);
        });
    });
}

} // namespace tasks_ng
} // namespace wiki
} // namespace maps
