#pragma once

#include <maps/wikimap/mapspro/services/tasks-ng/lib/xml_response_wrapper.h>
#include <util/system/compiler.h>

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace tasks_ng {

void makeResponseError(
    XmlResponseWrapper& wrapper,
    const std::string& status,
    const std::string& what);


class Error : public maps::Exception
{
public:
    explicit Error(std::string status)
        : status_(std::move(status))
    {}

    const auto& status() const { return status_; }

private:
    std::string status_;
};

#define DECLARE_ERR_CODE(code) const std::string code = #code

DECLARE_ERR_CODE( ERR_BAD_REQUEST );
DECLARE_ERR_CODE( ERR_FORBIDDEN );
DECLARE_ERR_CODE( ERR_NOT_FOUND );
DECLARE_ERR_CODE( INTERNAL_ERROR );
DECLARE_ERR_CODE( TASK_NOT_REVOCABLE );
DECLARE_ERR_CODE( TASK_NOT_RESUMABLE );

#define THROW_TASKS_ERROR(status, cause) \
    throw maps::wiki::tasks_ng::Error(status) << cause

#define THROW_TASKS_INTERNAL_ERROR \
    throw maps::wiki::tasks_ng::Error(INTERNAL_ERROR)

#define TASKS_REQUIRE(cond, status, msg) \
    if (Y_LIKELY(cond)) {} else \
        THROW_TASKS_ERROR(status, msg)

} // namespace tasks_ng
} // namespace wiki
} // namespace maps
