#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/json/include/value.h>

#include <maps/wikimap/mapspro/services/tasks-ng/lib/common.h>

#include <string>

namespace maps {
namespace wiki {
namespace tasks_ng {

class Config;

enum class GrinderTaskStatus {
    New,
    Queued,
    Assigned,
    Started,
    Postponed,
    Finished,
    Failed,
    Canceled
};

DECLARE_ENUM_IO(GrinderTaskStatus);


struct GrinderTaskResult
{
    int64_t timestampMs = 0;
    GrinderTaskStatus status = GrinderTaskStatus::New;
    std::string pid;
    std::string msg;

    ServiceTaskStatus serviceTaskStatus() const;
};

class GrinderGateway
{
public:
    explicit GrinderGateway(const Config& config);

    GrinderTaskResult tryGetTaskResult(
        Id taskId,
        const GrinderTaskId& grinderTaskId) const;

    GrinderTaskId submitTask(Id taskId, const json::Value& parameters) const;

    bool tryCancelTask(Id taskId, const GrinderTaskId& grinderTaskId) const;

private:
    GrinderTaskResult getTaskResult(const GrinderTaskId& grinderTaskId) const;
    GrinderTaskId submitTask(const json::Value& parameters) const;
    bool cancelTask(const GrinderTaskId& grinderTaskId) const;

    std::string grinderHost_;
};

} // namespace tasks_ng
} // namespace wiki
} // namespace maps
