#pragma once

#include <boost/lexical_cast.hpp>

#include <maps/infra/yacare/include/request.h>

#include <algorithm>
#include <cctype>
#include <map>
#include <optional>
#include <vector>
#include <string>
#include <unordered_map>

namespace maps {
namespace wiki {
namespace tasks_ng {

struct FileInRequest
{
    std::string fileName;
    std::string fileBody;
};

using FilesInRequest = std::unordered_map<std::string, FileInRequest>;

class RequestParameters
{
public:
    explicit RequestParameters(const yacare::QueryParams& data, FilesInRequest filesInRequest = {})
        : data_(data)
        , filesInRequest_(std::move(filesInRequest))
    {
    }

    template <typename T>
    T getValue(const std::string& key, const T& defaultValue) const
    {
        auto it = data_.find(key);
        if (it != data_.end() && !it->second.empty()) {
            const auto& firstValue = it->second.front();
            if (!firstValue.empty()) {
                return castValue<T>(firstValue);
            }
        }
        return defaultValue;
    }

    std::optional<FileInRequest> getFile(const std::string& paramName) const
    {
        auto it = filesInRequest_.find(paramName);
        if (it != filesInRequest_.end()) {
            return it->second;
        }
        return std::nullopt;
    }

private:
    template <typename T>
    static T castValue(const std::string& value)
    {
        return boost::lexical_cast<T>(value);
    }

    const yacare::QueryParams& data_;
    const FilesInRequest filesInRequest_;
};

template <>
inline bool RequestParameters::castValue<bool>(const std::string& value)
{
    if (value == "1") {
        return true;
    }

    static const std::string TRUE = "true";
    return std::equal(
        value.begin(), value.end(), TRUE.begin(), TRUE.end(),
        [](char a, char b) { return tolower(a) == tolower(b); });
}


} // namespace tasks_ng
} // namespace wiki
} // namespace maps
