#include <maps/wikimap/mapspro/services/tasks-ng/lib/task_module.h>
#include <maps/wikimap/mapspro/services/tasks-ng/lib/exception.h>

#include <maps/libs/json/include/value.h>
#include <algorithm>

namespace maps {
namespace wiki {
namespace tasks_ng {

void TaskModule::capabilities(XmlWriter& writer) const
{
    auto nm = name();

    // to xml tag (replace '_' to '-')
    std::replace_if(
        nm.begin(),
        nm.end(),
        [](char c) { return c == '_'; },
        '-');

    writer.addTag(nm + "-task-type");
}

void TaskModule::onCreate(DbContext&, Task&, const RequestParameters&) const
{
    THROW_TASKS_INTERNAL_ERROR << "Not implemented creating task type: " << name();
}

json::Value TaskModule::launchParameters(const Task&) const
{
    return json::null;
}

} // namespace tasks_ng
} // namespace wiki
} // namespace maps
