#pragma once

#include <maps/libs/json/include/value.h>

#include <maps/wikimap/mapspro/services/tasks-ng/lib/db_context.h>
#include <maps/wikimap/mapspro/services/tasks-ng/lib/request_parameters.h>
#include <maps/wikimap/mapspro/services/tasks-ng/lib/task.h>
#include <maps/wikimap/mapspro/services/tasks-ng/lib/xml_writer.h>

namespace maps {
namespace wiki {
namespace tasks_ng {

class TaskModule
{
public:
    TaskModule() = default;
    virtual ~TaskModule() = default;

    virtual std::string name() const = 0;

    virtual void capabilities(XmlWriter&) const;

    virtual void loadContext(DbContext&, Task&) const {}
    virtual void loadResult(DbContext&, Task&) const {}

    virtual void onCreate(DbContext&, Task&, const RequestParameters&) const;

    virtual json::Value launchParameters(const Task&) const;
};

} // namespace tasks_ng
} // namespace wiki
} // namespace maps
