#include <maps/wikimap/mapspro/services/tasks-ng/lib/task_module_registry.h>

#include <maps/wikimap/mapspro/services/tasks-ng/lib/exception.h>

namespace maps {
namespace wiki {
namespace tasks_ng {

TaskModuleRegistry& TaskModuleRegistry::get()
{
    static TaskModuleRegistry registry;
    return registry;
}

std::shared_ptr<TaskModule> TaskModuleRegistry::modulePtr(
    const std::string& taskType) const
{
    std::lock_guard<std::mutex> lock(mutex_);
    auto it = modules_.find(taskType);
    if (it == modules_.end()) {
        return {};
    }
    return it->second;
}

const TaskModule& TaskModuleRegistry::module(const std::string& taskType) const
{
    auto module = modulePtr(taskType);
    TASKS_REQUIRE(module, ERR_NOT_FOUND, taskType << " not found");
    return *module;
}

std::vector<std::shared_ptr<TaskModule>> TaskModuleRegistry::allModules() const
{
    std::lock_guard<std::mutex> lock(mutex_);

    std::vector<std::shared_ptr<TaskModule>> result;
    result.reserve(modules_.size());
    for (const auto& [name, module] : modules_) {
        result.emplace_back(module);
    }
    return result;
}

void TaskModuleRegistry::add(std::shared_ptr<TaskModule> taskModule)
{
    ASSERT(taskModule);
    auto taskType = taskModule->name();
    std::lock_guard<std::mutex> lock(mutex_);
    auto res = modules_.emplace(taskType, std::move(taskModule));
    REQUIRE(res.second, "Module already exists: " << taskType);
}

} // namespace tasks_ng
} // namespace wiki
} // namespace maps
